(defmeth scatterplot-proto :add-true-reg-line ()
"Adds a regression line. A kludge adapted from color regression lines"
  (let* (
         ;(line? (send self :add-linear))
         (visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                   (send self :point-state (iseq (send self :num-points))))))
         (x (send self :point-coordinate (first (send self :current-variables)) visible))
                          
         (y (send self :point-coordinate (second (send self :current-variables)) visible))
         (var-colors (send self :point-color visible))
         (colors (remove-duplicates var-colors :test #'equal))
         (colors (list 'blue));changed for using all the points
         (points-in-color (list visible));changed for using all the points
         )

    (mapcar #'(lambda (pincolor c)
                (cond 
                  ((= (length pincolor) 1)
                   nil)
                  ((= (length pincolor) 2)
                   (send self :add-lines (select x pincolor) (select y pincolor) :color c))
                  (t 
                   (let* ((c c)
                          (rg-coef (send (regression-model (select x pincolor) 
                                                           (select y pincolor) :print nil) :coef-estimates))
                          
                          (xs (list (min (select x pincolor)) (max (select x pincolor))))
                          (fullxs (list (list (min x) (first xs)) (list (second xs) (max x))))
                          (ys (mapcar #'(lambda (xx) (+ (first rg-coef) (* (second rg-coef) xx))) xs))
                          
                          (fullys (mapcar #'(lambda (fxs)
                                              (mapcar #'(lambda (xx) 
                                                          (+ (first rg-coef) (* (second rg-coef) xx))) fxs))
                                          fullxs)))
                     (send self :add-lines (send self :make-high-d-lines xs ys) :color c )
                     (mapcar #'(lambda (fx fy) (send self :add-lines (send self :make-high-d-lines fx fy) :color c :type 'dashed )) fullxs fullys)
                     ))
                ))
            points-in-color colors)

    ))


(defmeth scatterplot-proto :deactivate-pattern-lines ()
  (defmeth self :adjust-screen ()
    (call-next-method)))

(defmeth scatterplot-proto :activate-pattern-lines ()

  (send self :add-slot 'cases-by-pattern)
  (defmeth self :cases-by-pattern (&optional (cases-by-pattern nil set))
    (if set (setf (slot-value 'cases-by-pattern) cases-by-pattern))
    (slot-value 'cases-by-pattern))

  (send self :add-slot 'abcoefs)
  (defmeth self :abcoefs (&optional (abcoefs nil set))
    (if set (setf (slot-value 'abcoefs) abcoefs))
    (slot-value 'abcoefs))
  
  (defmeth self :adjust-screen ()
    ;(call-next-method)
    
    (send self :add-line-by-pattern)
    )

(defmeth scatterplot-proto :add-line-by-pattern ()
"Adds regression lines by pattern. A kludge adapted from color regression lines"
  (let* (
         (visibles-in-pattern (send self :cases-by-pattern))
         (visible (which (mapcar #'(lambda (s) (not (equal s 'invisible))) 
                                   (send self :point-state (iseq (send self :num-points))))))
         (x (send self :point-coordinate (first (send self :current-variables)) visible))
                          
         (y (send self :point-coordinate (second (send self :current-variables)) visible))
         ;(visibles-in-pattern (mapcar #'(lambda (pat) ;(set-difference pat visible)
          ;                                pat)
           ;                           cases-in-patterns))
         )
    (send self :clear-lines)

    (mapcar #'(lambda (pincolor)
                (cond 
                  ((= (length pincolor) 1)
                   nil)
                  ((= (length pincolor) 2)
                   (send self :add-lines (select x pincolor) (select y pincolor) :color 'blue))
                  ((and (variancep (select x pincolor)) (variancep (select y pincolor)))
                   (let* ((c 'blue)
                          (rg-coef (send (regression-model (select x pincolor) 
                                                           (select y pincolor) :print nil) :coef-estimates))
                          
                          (xs (list (min (select x pincolor)) (max (select x pincolor))))
                          (fullxs (list (list (min x) (first xs)) (list (second xs) (max x))))
                          (ys (mapcar #'(lambda (xx) (+ (first rg-coef) (* (second rg-coef) xx))) xs))
                          
                          (fullys (mapcar #'(lambda (fxs)
                                              (mapcar #'(lambda (xx) 
                                                          (+ (first rg-coef) (* (second rg-coef) xx))) fxs))
                                          fullxs)))
                     (send self :add-lines (send self :make-high-d-lines xs ys) :color c)
                     (mapcar #'(lambda (fx fy) 
                                 (send self :add-lines (send self :make-high-d-lines fx fy) :color c :type 'dashed ))
                             fullxs fullys)
                     ))
                  (t nil)
                  ))
            visibles-in-pattern)
   
    (when (and (send self :cases-by-pattern) (send self :abcoefs)) (apply 'send self :abline (send self :abcoefs)))
    ))
  )